# Migrations
These are Laravel's migrations, require a Laravel command line application.

## Installation
In you console app register `MigrationsServiceProvider` before creating the app object.
```
// Instantiate the container (Replace your main applications container with the 
extended class)
$app = new \MtcMedia\Migrations\FoundationApplication();

// ...

// Example Console app
$path = "../";
require_once $path . "includes/header.inc.php";

$app = \Illuminate\Support\Facades\App::getFacadeRoot();
$events = \Illuminate\Support\Facades\Event::getFacadeRoot();

// migrations - register before creatign the app, so that it hooks to an event and register all commands automatically
(new \MtcMedia\Migrations\MigrationsServiceProvider($app))->register();

$console = new \Illuminate\Console\Application($app, $events, '1.0');// new Symfony\Component\Console\Application();

// add more commands

$console->run();
```

## Usage 
Just use instructions from the Laravel documentation: 
https://laravel.com/docs/5.2/migrations replacing `php artisan` with a call to your
console app, e.g. `php cli/app.php`:

* `php cli/app.php make:migration --create=table_name`
* `php cli/app.php make:migration --table=table_name`
* `php cli/app.php migrate`
* `php cli/app.php migrate:rollback`

This has replaced `phinx` migrations which required a bunch of CakePhp libraries and 
maintaining a separate file with database credentials.  

Due to a bug in Laravel, rolling back requires `database/migrations/` folder to be set up for 
`classmap` autoloading and `composer dump-autoload` run before running the rollback
command.
