<?php

namespace MtcMedia\Migrations;

use Illuminate\Database\Capsule\Manager as Capsule;
use Phinx\Migration\AbstractMigration;


/**
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@gmail.com>
 * @version 06.01.2017.
 */
class Migration extends AbstractMigration
{
    /** @var \Illuminate\Database\Capsule\Manager $capsule */
    public $capsule;
    /** @var \Illuminate\Database\Schema\Builder $capsule */
    public $schema;

    public function setAdapter(\Phinx\Db\Adapter\AdapterInterface $adapter)
    {
        parent::setAdapter($adapter);

        $options = $this->getAdapter()->getOptions();

        $this->capsule = new Capsule;
        $this->capsule->addConnection([
            'driver'    => 'mysql',
            'host'      => $options['host'],
            //'port'      => $options['port'],
            'database'  => $options['name'],
            'username'  => $options['user'],
            'password'  => $options['pass'],
            'charset'   => 'utf8',
            'collation' => 'utf8_unicode_ci',
        ]);

        $this->capsule->bootEloquent();
        $this->capsule->setAsGlobal();

        // Override MySQL grammar the our own that provides extensions like the SET type
        $this->capsule->getConnection()->setSchemaGrammar(new ExtendedMySqlGrammar());

        $this->schema = $this->capsule->schema();

        // Override the bluprint with the extended version that provides a convenience set() method
        $this->schema->blueprintResolver(function($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        return $this;
    }
}
