<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Default Currency
    |--------------------------------------------------------------------------
    |
    | This currency will be used unless user has switched to a different currency
    |
    */
    'default_currency' => 'GBP',

    /*
    |--------------------------------------------------------------------------
    | Currency Locales
    |--------------------------------------------------------------------------
    |
    | These are used to format the price output.
    |
    */
    'locales' => [
        'EUR' => 'de_DE.UTF-8',
        'GBP' => 'en_GB.UTF-8',
        'USD' => 'en_US.UTF-8',
        'JPY' => 'ja_JP.UTF-8',
        'RUB' => 'ru_RU.UTF-8',
    ],

    /*
    |--------------------------------------------------------------------------
    | Round Price Attribute
    |--------------------------------------------------------------------------
    |
    | These are used to round price attribute before loading Price Model.
    |
    | mode: PHP_ROUND_HALF_UP ,PHP_ROUND_HALF_DOWN, PHP_ROUND_HALF_EVEN, PHP_ROUND_HALF_ODD
    */
    'round' => [
        'precision' => 2,
        'mode' => PHP_ROUND_HALF_UP
    ]
];
