<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Tax
    |--------------------------------------------------------------------------
    |
    | Choose whether tax is applied.
    |
    */
    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Price Entry
    |--------------------------------------------------------------------------
    |
    | The option specifies whether prices are entered with or without tax. If
    | true, this means that all catalog prices are input using your store's
    | base tax rate. If false, this would mean that your catalog prices need
    | to be be tax exclusive.
    |
    */
    'price_entered_with_tax' => true,

    /*
    |--------------------------------------------------------------------------
    | Display Prices
    |--------------------------------------------------------------------------
    |
    | Prices should be displayed with or without tax.
    | This will affect the default display value
    |
    */
    'display_with_tax' => true,

    /*
    |--------------------------------------------------------------------------
    | Price Display Suffix
    |--------------------------------------------------------------------------
    |
    | Allows you to change display to: “Prices include __% tax/VAT” or anything
    | appropriate for your store. You can use these two placeholders if you
    | want to have text before and after the price:
    |   - {price_including_tax}
    |   - {price_excluding_tax}
    |
    */
    'price_display_suffix' => '',

    /*
    |--------------------------------------------------------------------------
    | Price Precision
    |--------------------------------------------------------------------------
    |
    | The precision of tax calculations in decimal places.
    | Used to calculate tax on price
    |
    */
    'price_calculation_precision' => 3,

    /*
    |--------------------------------------------------------------------------
    | Default Tax Rate
    |--------------------------------------------------------------------------
    |
    | Which Tax rate will be used unless a different one is specified
    |
    */
    'default_vat_rate' => 'Standard',

    /*
    |--------------------------------------------------------------------------
    | Tax Rates
    |--------------------------------------------------------------------------
    |
    | Supported Tax Rates.
    |
    */
    'vat_rates' => [
        'Standard' =>  0.2,
        'Reduced rate' => 0.05,
        'No Tax' => 0,
    ]
];
