<?php

namespace Mtc\Money\Events;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;

class LoadPriceModifiers
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Model for whom the price modifiers are loaded
     *
     * @var Model
     */
    public $model;

    /**
     * Price attribute key on model
     *
     * @var string
     */
    public $attribute_key;

    /**
     * Tax rate applied to price
     *
     * @var float
     */
    public $tax_rate;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($model, $attribute_key, $tax_rate)
    {
        $this->model = $model;
        $this->attribute_key = $attribute_key;
        $this->tax_rate = $tax_rate;
    }
}
