<?php

namespace Mtc\Money\Facades;

use Illuminate\Support\Facades\Facade;

/**
 * @see \Mtc\Money\Currency
 * @method static getCurrentCurrency(): string
 * @method static getDefaultCurrency(): string
 * @method static setActiveCurrency($currency): void
 * @method static inCurrency($amount, $currency = null): float
 * @method static inBaseCurrency($amount, $currency = null): float
 */
class Currency extends Facade
{
    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'currency';
    }
}
