<?php

namespace Mtc\Money\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\Money\Facades\Currency;

/**
 * Class MoneyServiceProvider
 *
 * @package Mtc\Money
 */
class MoneyServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(\dirname(__DIR__, 2) . '/config/tax.php', 'tax');
        $this->mergeConfigFrom(\dirname(__DIR__, 2) . '/config/currencies.php', 'currencies');

        // Register the main class to use with the facade
        $this->app->singleton('currency', \Mtc\Money\Currency::class);
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                \dirname(__DIR__, 2) . '/config/tax.php' => config_path('tax.php'),
            ], 'config');

            $this->publishes([
                \dirname(__DIR__, 2) . '/config/currencies.php' => config_path('currencies.php'),
            ], 'config');
        }
    }
}
