<?php

namespace Tests\Unit;

use Mtc\AutomotiveSpecs\VehicleSpecification;
use Mtc\MotorCheck\Maps\MotorSpecsToVehicleSpecification;
use Mtc\Tests\TestCase;

class MotorSpecVehicleMapTest extends TestCase
{
    public function testSpecMapFields()
    {

        $mapper = new MotorSpecsToVehicleSpecification(new VehicleSpecification());
        $spec =  $mapper->map([
            'identity' => [
                'vehicleId' => '/abcdef123444aa=',
                'specsVehicle' => [
                    'make' => 'AUDI',
                    'model' => 'A6',
                    'modelYear' => 2019,
                    'version' => 'A6 Avantis TDi Quattro',
                    'engineCC' => 2999,
                    'body' => 'ESTATE',
                    'transmission' => 'MANUAL',
                    'fuel' => 'DIESEL',

                ],
                'vehicle' => [
                    'dvla' => [
                        'co2' => 199,
                    ],
                    'combined' => [
                        'regDate' => '2019-01-02',
                        'colour' => 'Yellow',
                        'currentMiles' => 123456,
                        'registration' => 'G4M3L0'
                    ],
                    'mvris' => [
                        'combinedMpg' => 32,
                        'driveType' => '4x4',
                    ]
                ]
            ],
            'standard' => [
                'standardSpecification' => [
                    [
                        'Category' =>  [
                            [
                                'name' => 'Name',
                                'description' => 'Value',
                            ]
                        ]
                    ]
                ]
            ]
        ]);

        self::assertEquals('Audi', $spec->make);
        self::assertEquals('A6', $spec->model);
        self::assertEquals(2019, $spec->model_year);
        self::assertEquals('A6 Avantis TDi Quattro', $spec->derivative);
        self::assertEquals(2999, $spec->engine_size);
        self::assertEquals(199, $spec->co2);
        self::assertEquals('Estate', $spec->body_style);
        self::assertEquals('Manual', $spec->transmission);
        self::assertEquals('Diesel', $spec->fuel_type);
        self::assertEquals('Yellow', $spec->colour);
        self::assertEquals('/abcdef123444aa=', $spec->UUID);
        self::assertEquals('2019-01-02', $spec->registration_date);
        self::assertEquals('G4M3L0', $spec->registration_number);
        self::assertEquals('mi', $spec->odometer_metric);
        self::assertEquals('123456', $spec->odometer_value);
        self::assertEquals('32', $spec->mpg);
        self::assertEquals('4x4', $spec->drivetrain);
        $feature_value = [
            [
                'name' => 'Name',
                'value' => 'Value',
                'type' => 'Category'
            ]
        ];
        self::assertEquals($feature_value, $spec->feature_list);
    }
}
