<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMotorCheckTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('motor_check_specs', function (Blueprint $table) {
            $table->id();
            $table->string('vrm', 20)->index();
            $table->integer('mileage')->index()->nullable();
            $table->string('uuid')->index()->nullable();
            $table->longText('identity')->nullable();
            $table->longText('standard')->nullable();
            $table->timestamps();
        });

        Schema::create('motor_check_valuations', function (Blueprint $table) {
            $table->id();
            $table->string('vrm', 20)->index();
            $table->integer('mileage')->index()->nullable();
            $table->longText('vipValuation')->nullable();
            $table->longText('autotraderValuation')->nullable();
            $table->timestamps();
        });

        Schema::create('motor_check_risks', function (Blueprint $table) {
            $table->id();
            $table->string('vrm', 20)->index();
            $table->longText('data')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('motor_check_specs');
        Schema::dropIfExists('motor_check_valuations');
        Schema::dropIfExists('motor_check_risks');
    }
}
