<?php

namespace Mtc\MotorCheck\Traits;

use Carbon\Carbon;
use Mtc\MotorCheck\Models\MotorCheckValuation;

trait CachesValuations
{
    protected function canUseCachedValuationResponse(string $vrm): bool
    {
        return ($this->config['allow_local_cache'] ?? false)
            && $this->valuationRecordExists($vrm);
    }

    protected function valuationRecordExists(string $vrm): bool
    {
        return MotorCheckValuation::query()
            ->where('vrm', $vrm)
            ->where('updated_at', '>=', Carbon::now()->subMonths(3))
            ->exists();
    }

    protected function loadValuationFromCache(string $vrm): array
    {
        return MotorCheckValuation::query()
            ->where('vrm', $vrm)
            ->firstOrFail()
            ->only([
                'vipValuation',
                'autotraderValuation',
            ]);
    }

    protected function cacheValuationIfAble(string $vrm, int $mileage, array $valuation_data)
    {
        if (($this->config['allow_local_cache'] ?? false) !== true) {
            return;
        }

        MotorCheckValuation::query()
            ->updateOrCreate([
                'vrm' => $vrm,
            ], [
                'mileage' => $mileage,
                'vipValuation' => $valuation_data['vipValuation'] ?? null,
                'autotraderValuation' => $valuation_data['autotraderValuation'] ?? null,
            ]);
    }
}
