<?php

namespace Mtc\MotorCheck\Traits;

use Mtc\MotorCheck\Models\MotorCheckSpec;

trait CachesSpecs
{
    protected function canUseCachedSpecsResponse(string $vrm, int $mileage): bool
    {
        return ($this->config['allow_local_cache'] ?? false)
            && $this->specRecordExists($vrm, $mileage);
    }

    protected function specRecordExists(string $vrm, int $mileage): bool
    {
        return MotorCheckSpec::query()
            ->where('vrm', $vrm)
            ->exists();
    }

    protected function loadSpecsFromCache(string $vrm): array
    {
        return MotorCheckSpec::query()
            ->where('vrm', $vrm)
            ->firstOrFail()
            ->only([
                'identity',
                'standard'
            ]);
    }

    protected function cacheSpecsIfAble(string $vrm, int $mileage, array $spec_data)
    {
        if (($this->config['allow_local_cache'] ?? false) !== true) {
            return;
        }

        MotorCheckSpec::query()
            ->updateOrCreate([
                'vrm' => $vrm,
            ], [
                'mileage' => $mileage,
                'uuid' => $spec_data['identity']['vehicle_id'] ?? null,
                'identity' => $spec_data['identity'],
                'standard' => $spec_data['standard']
            ]);
    }
}
