<?php

namespace Tests\Unit;

use Mtc\AutomotiveSpecs\VehicleRisks;
use Mtc\MotorCheck\Maps\MotorCheckRiskMap;
use Mtc\Tests\TestCase;

class MotorCheckRiskMapTest extends TestCase
{
    public function testPricesOnValuation()
    {
        $mapper = new MotorCheckRiskMap(new VehicleRisks());
        $risks = $mapper->map([
            'data' => [
                'issues' => [
                    'finance' => [
                        'flag' => false,
                        'message' => '',
                    ],
                    'stolen' => [
                        'flag' => true,
                        'message' => 'Stolen in 2011',
                    ],
                    'mileage' => [
                        'flag' => true,
                        'message' => 1,
                    ],
                    'atRisk' => [
                        'flag' => true,
                        'message' => 2,
                    ],
                    'writeOff' => [
                        'flag' => true,
                        'message' => 'Write-off in 2012',
                    ],
                    'conditionAlerts' => [
                        'flag' => true,
                        'message' => 'Rusted frame',
                    ],
                    'scrapped' => [
                        'flag' => true,
                        'message' => 'Sold for parts',
                    ],
                    'keepers' =>[
                        'flag' => true,
                        'message' => 99,
                    ],
                    'plateChange' => [
                        'flag' => true,
                        'message' => 3,
                    ],
                    'colourChanges' => [
                        'flag' => true,
                        'message' => 4,
                    ],
                    'motHistory' => [
                        'flag' => true,
                        'message' => 'No MOT',
                    ],
                    'taxAndSorn' => [
                        'flag' => true,
                        'message' => 5,
                    ],
                    'originAndUse' => [
                        'flag' => true,
                        'message' => 6,
                    ],
                ]
            ]
        ]);

        self::assertEquals(false, $risks->finance);
        self::assertEquals(1, $risks->mileage);
        self::assertEquals(2, $risks->at_risk);
        self::assertEquals(3, $risks->plate_change);
        self::assertEquals(4, $risks->colour_changes);
        self::assertEquals(5, $risks->tax_and_sorn);
        self::assertEquals(6, $risks->origin_and_use);
        self::assertEquals(99, $risks->keepers);
        self::assertEquals('Stolen in 2011', $risks->stolen);
        self::assertEquals('Write-off in 2012', $risks->write_off);
        self::assertEquals('Rusted frame', $risks->condition);
        self::assertEquals('Sold for parts', $risks->scrapped);
        self::assertEquals('No MOT', $risks->mot_history);
    }
}
