<?php

namespace Mtc\MotorCheck\Traits;

use Carbon\Carbon;
use Mtc\MotorCheck\Models\MotorCheckRisk;

trait CachesRisks
{
    protected function canUseCachedRiskResponse(string $vrm): bool
    {
        return ($this->config['allow_local_cache'] ?? false)
            && $this->riskRecordExists($vrm);
    }

    protected function riskRecordExists(string $vrm): bool
    {
        return MotorCheckRisk::query()
            ->where('vrm', $vrm)
            ->exists();
    }

    protected function loadRisksFromCache(string $vrm): array
    {
        return MotorCheckRisk::query()
            ->where('vrm', $vrm)
            ->firstOrFail([
                'data',
            ])->toArray();
    }

    protected function cacheRisksIfAble(string $vrm, array $data)
    {
        if (($this->config['allow_local_cache'] ?? false) !== true) {
            return;
        }

        MotorCheckRisk::query()
            ->updateOrCreate([
                'vrm' => $vrm,
            ], [
                'data' => $data['data'],
            ]);
    }
}
