<?php
use Mtc\Core\Images\ImageOptimise;
/**
 * Plugin.php
 *
 * Class to losslessly optimize images uploaded to MoxieManager.
 * Optimized file overwrites original one.
 *
 * @author Reinis Liepkalns | mtc.
 * @version 2016-08-12
 */
class MOXMAN_ImageOptimizer_Plugin implements MOXMAN_IPlugin
{
    /**
     * Binds onFileAction() method to MoxieManager's FileAction event.
     *
     * @return void
     */
    public function init()
    {
        MOXMAN::getPluginManager()->get("core")->bind("FileAction", "onFileAction", $this);
    }

    /**
     * This method is attached to MoxieManagers file action event. It will be
     * called every time there is a file action in MoxieManager. It will then
     * check if that action is "ADD" and if it is, it will get the path to added
     * file and will call an imageOptimiseLossless() method on it.
     *
     * @param object $args MoxieManagers File Action Event Args object
     *
     * @return void
     */
    public function onFileAction(MOXMAN_Vfs_FileActionEventArgs $args)
    {
        if ($args->getAction() == MOXMAN_Vfs_FileActionEventArgs::ADD) {
            $image = $args->getFile();
            $image_path = $image->getPath();
            $this->imageOptimiseLossless($image_path);
        }
    }

    /**
     * This method will attempt to losslessly optimise an image. If it
     * succeeds, it will then overwrite the original one with the new optimised.
     *
     * @param string $filepath Location of the image.
     *
     * @return void
     */
    private function imageOptimiseLossless($filepath)
    {
        ImageOptimise::optimizeLosslessly($filepath, IMAGE_OPTIMISE_LOSSLESS);
    }
}

// Add plugin
MOXMAN::getPluginManager()->add("ImageOptimise", new MOXMAN_ImageOptimizer_Plugin());
