<?php

namespace Mtc\MoxieManager\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;

/**
 * Class MoxieController
 *
 * @package Mtc\MoxieManager\Http\Controllers
 */
class MoxieController extends Controller
{
    /**
     * Pass through a moxie-manager asset
     *
     * @param $path
     */
    public function passthru($path)
    {
        $file_details = (pathinfo($path));
        $path_to_file = dirname(__DIR__, 3) . '/lib/' . $path;

        if (File::exists($path_to_file) === false) {
            return abort(404);
        }

        switch ($file_details['extension']) {
            case 'js':
                header('Content-Type: application/javascript');
                break;
            case 'css':
                header('Content-Type: text/css');
                break;
            default:
                break;
        }

        require_once $path_to_file;
        exit;

    }

}
