# Mtc Login Package

This package adds ability to verify if the user trying to log in 
with mtc credentials is a valid user.

## Installation and Usage

```
composer require mtcmedia/mtc-login
```

If you are on __mtc platform project__ that is it.

If you are on __native Laravel project__ you might want to 
set a custom master role if project uses `spatie/laravel-permission`.
This would be done by setting up `config/mtc_login.php` file and 
setting `mtc_user_role` value there.

For __any other platforms__ you can still use this package by setting up
the login check flow:
```php
if ($is_mtc_login && $should_check) {
    
    $client = new GuzzleHttp\Client; 
    $service = new Mtc\Login\LoginService($client);
    if ($service->isValidUser($email, $password)) {
        // let through and save user if necessary
    } else {
        // block user
    }
}
```
