<?php

namespace Mtc\Login\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\App;
use Mtc\Core\Admin\User;
use Mtc\Login\LoginService;

/**
 * Class CheckOldStaff
 *
 * @package Mtc\Login
 */
class CheckOldStaff implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        /** @var LoginService $service */
        $service = App::make(LoginService::class);
        $emails = User::query()
            ->where('email', 'like', '%@mtcmedia.co.uk')
            ->pluck('email')
            ->toArray();

        $old_emails = $service->filterOldUsers($emails);

        if (empty($old_emails)) {
            return;
        }

        User::query()
            ->whereIn('email', $old_emails)
            ->delete();
    }
}
