<?php

namespace Mtc\Login;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;

/**
 * Class LoginService
 *
 * @package Mtc\Login
 */
class LoginService
{
    /**
     * API client
     *
     * @var Client
     */
    protected $client;

    /**
     * LoginService constructor.
     *
     * @param Client $client
     */
    public function __construct(Client $client)
    {
        $this->client = $client;
    }

    /**
     * Check if provided credentials are for a valid user
     *
     * @param $email
     * @param $password
     * @return array|bool|mixed|null
     */
    public function isValidUser($email, $password)
    {
        try {
            $response = $this->client
                ->post($this->endpoint('api/staff_login.php'), [
                    'connect_timeout' => 3,
                    'form_params' => [
                        'email' => $email,
                        'password' => $password
                    ]
                ]);

            $response = json_decode($response->getBody(), true);
            return is_array($response) ? $response : null;
        } catch (ClientException $e) {
            return false;
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * Perform a search for old emails in the system from the list
     *
     * @param array $emails
     * @return array|bool|mixed|null
     */
    public function filterOldUsers($emails = [])
    {
        try {
            $response = $this->client
                ->post($this->endpoint('api/staff/check-old'), [
                    'connect_timeout' => 3,
                    'form_params' => [
                        'api_token' => config('mtc_login.api_token'),
                        'emails' => $emails,
                    ]
                ]);

            $response = json_decode($response->getBody(), true);
            return is_array($response) ? $response : null;
        } catch (ClientException $e) {
            return false;
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * Find the endpoint
     *
     * @param $path
     * @return string
     */
    protected function endpoint($path)
    {
        return rtrim(config('mtc_login.api_domain'), '/') . '/' . ltrim($path, '/');
    }
}
