# MTC Pay - Stripe Connect
This package provides payment processing through MTC Pay (a Stripe Connect SASS).

## Installation and Setup

1. Install the package by running `composer require mtcmedia/mtc-pay-payments`.
2. To publish the required JS assets, run `php artisan install:components`.
3. Ask the PM to retrieve the config key from MTC Pay. Save this in `.env` under `MTC_PAY_CONFIG`.

On the test environment the payment gateway will show test cards automatically on the payment page.

## Configuration

The config is stored in `config/mtc_pay.php` and can be published via `php artisan vendor:publish --tag=config`. Each
config has a description which explains their use.

### Language

The default language settings are defined in `resources/lang/en/`. At the moment only `checkout.php` is defined.

This is used to define the gateway name, button text, and processing state text.

This can be published if changes are needed by running `php artisan vendor:publish --provider="Mtc\\MtcPay\\Providers\\MtcPayServiceProvider::class"`.

## Payment Workflow

1. We load the PaymentForm onto the website (`mtc_pay_form.vue`), which injects Stripe's JS libraries.
2. This runs `Mtc\MtcPay\Http\Controllers\MtcPayController@index` which then asks MTC Pay to generate a Payment Intent
   for us. We send only the basic details back to the browser.
3. Stripe's JS library will automatically confirm the PaymentIntent, taking the customer to the default 
   checkout `charge_payment` route.
4. This will run `Mtc\MtcPay\MtcPay@charge` which will ask MTC Pay for the payment intent, and confirm that this has
   completed successfully.

## Troubleshooting

### Implement Apple Pay

The current domain will need to be authenticated by Stripe before we can show Apple Pay. Once authenticated, this will
appear as a tab next to Card within the payment gateway window.

1. Download the [verification file from Stripe](https://stripe.com/files/apple-pay/apple-developer-merchantid-domain-association)
   and upload to your website here: `https://example.com/.well-known/apple-developer-merchantid-domain-association`.
2. Provide Dave / Craig a link to the file location, which will be added to
3. [Stripe's Apple Pay Dashboard](https://dashboard.stripe.com/settings/payments/apple_pay).

This is needing to be done per-domain, so twice if both staging and live are required.

### Upgrading

1. Run `composer update`.
2. Run `php artisan vendor:publish --force --provider="Mtc\\MtcPay\\Providers\\MtcPayServiceProvider::class"` to update both
   JS assets and config files. If you want to restrict to just JS, add `--tag=assets` to the end of the command. Failure
   to run the publish command may result in the frontend working unexpectedly if necessary changes have been made.