<?php

return [
    /**
     |--------------------------------------------------------------------------
     | MTC Pay API Config Key
     |--------------------------------------------------------------------------
     | This can be retrieved from the specific gateway in MTC Pay under
     | Settings => API Key. This contains an encoded copy of the app
     | URL as well the specific API key to access MTC Pay's API.
     |
     */
    'config' => env('MTC_PAY_CONFIG'),

    /**
    |--------------------------------------------------------------------------
    | Payment Gateway Class
    |--------------------------------------------------------------------------
    | This class runs all the interactions to generate the payment
    | form, accepting new charges, and dealing with any refunds.
    | Override this if you need to make any bespoke changes.
    |
    */
    'payment_gateway_class' => Mtc\MtcPay\MtcPay::class,

    /**
    |--------------------------------------------------------------------------
    | Checkout Factory Class
    |--------------------------------------------------------------------------
    | This class facilitates generating the API request that is sent
    | to MTC Pay when we are trying to make a new payment intent.
    | Override this if you need to make any bespoke changes.
    |
    */
    'checkout_factory_class' => Mtc\MtcPay\CheckoutFactory::class,
];