<?php

namespace Mtc\MtcPay;

use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

/**
 * Convert an Invoice to the appropriate API Request.
 *
 * @package  Mtc\MtcPay
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class CheckoutFactory
{
    public function __invoke(InvoiceRepositoryContract $invoice): array
    {
        $billing = $invoice->getModel()->recipient;

        return [
            'type' => 'inline',
            'txn_ref' => $invoice->getId(),
            'description' => sprintf('Payment for %s Merchandise - Invoice %d', config('app.name'), $invoice->getId()),
            'amount' => $invoice->getOutstandingAmount() * 100,
            'currency' => strtolower($invoice->getCurrency()),
            'return_url' => route('charge_payment', [$invoice->getId(), 'gateway' => 'mtc_pay']),
            'notify_url' => null,
            'business' => [
                'name' => config('app.name'),
            ],
            'billing_details' => [
                'name' => sprintf('%s %s', $billing->first_name, $billing->last_name),
                'email' => $invoice->getEmail(),
                'phone' => $invoice->getModel()->contact_number ?? '',
                'address' => [
                    'line1' => $billing->address1 ?? '',
                    'line2' => $billing->address2 ?? '',
                    'city' => $billing->city ?? '',
                    'state' => $billing->state ?? '',
                    'country' => $billing->country ?? '',
                    'postal_code' => $billing->postcode ?? '',
                ]
            ],
            'metadata' => [
                'shop_url' => config('app.url'),
                'shop_id' => $invoice->getId(),
                'shop_version' => MtcPay::VERSION,
            ],
        ];
    }
}