<?php

namespace Mtc\MultiBuy\Contracts;

use Illuminate\Database\Eloquent\Model;

/**
 * Interface BasketDiscountRepositoryInterface
 * @package Mtc\MultiBuy\Contracts
 */
interface BasketDiscountRepositoryInterface
{
    /**
     * Get Discount Class
     *
     * @return Model
     */
    public function getDiscountClass();

    /**
     * Set Basket Repository
     *
     * @param $basket
     */
    public function setBasket($basket);

    /**
     * Set discounts for currect basket
     */
    public function setBasketDiscounts();

    /**
     * Check if discount is available for basket
     *
     * @param $discount
     * @return bool
     */
    public function availableForBasket($discount) : bool;

    /**
     * Check if discount is available for item
     *
     * @param $discount
     * @param $item
     * @return bool
     */
    public function availableForItem($discount, $item) : bool;

    /**
     * Get discount applicable items for current basket
     *
     * @param $discount
     * @return mixed
     */
    public function getDiscountApplicableItems($discount);
}
