<?php

use Illuminate\Routing\Router;
use Mtc\MultiBuy\Http\Controllers\Admin\DiscountController as AdminDiscountController;
use Mtc\MultiBuy\Http\Controllers\Admin\RestrictionController;
use Mtc\MultiBuy\Http\Controllers\Admin\StackablesController;

$router->group([
    'prefix' => '/admin',
    'middleware' => [
        'auth',
        'middleware' => 'permission:discounts'
    ]
], function (Router $router) {

    $router->get('discounts/{id}/stackables', StackablesController::class . '@index');
    $router->post('discounts/{id}/stackables/', StackablesController::class . '@store');
    $router->delete('discounts/{id}/stackables/{stackable_discount_id}', StackablesController::class . '@destroy');
    $router->get('discounts/{id}/stackables/search', StackablesController::class . '@search');

    $router->get('discounts/{id}/restrictions/{restriction}', RestrictionController::class . '@index');
    $router->post('discounts/{id}/restrictions/{restriction}', RestrictionController::class . '@store');
    $router->delete('discounts/restrictions/{restriction_id}', RestrictionController::class . '@destroy');
    $router->post('discounts/restrictions/{restriction_id}/toggle-exclude', RestrictionController::class . '@toggleExclude');
    $router->get('discounts/{id}/restrictions/{restriction}/search', RestrictionController::class . '@search');

    $router->resource('discounts', AdminDiscountController::class)->except(['show']);
});
