<?php

namespace Mtc\MultiBuy\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Relations\Relation;

/**
 * Class RestrictionController
 * @package Mtc\MultiBuy\Http\Controllers\Admin
 */
class RestrictionController extends Controller
{
    /**
     * Get restriction items
     *
     * @param Request $request
     * @param $discount_id
     * @param $restriction_name
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request, $discount_id, $restriction_name)
    {
        $restrictions = App::make('discount-restriction')
            ->newQuery()
            ->with('discountable')
            ->where('discountable_type', $restriction_name)
            ->where('discount_id', $discount_id)
            ->get();

        return response()->json([
            'restrictions' => $restrictions
        ]);
    }

    /**
     * Store restriction
     *
     * @param Request $request
     * @param $discount_id
     * @param $restriction_name
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function store(Request $request, $discount_id, $restriction_name)
    {
        if (!config('discounts.restrictions.' . $restriction_name)) {
            return response('Restriction not found', 404);
        }

        $discount = App::make('discount')->find($discount_id);
        $discount->restrictions()->create([
            'discountable_id' => $request->input('item'),
            'discountable_type' => $restriction_name,
        ]);
    }

    /**
     * Destroy restriction
     *
     * @param Request $request
     * @param $restriction_id
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function destroy(Request $request, $restriction_id)
    {
        $restrictions = App::make('discount-restriction')
            ->newQuery()
            ->where('id', $restriction_id)
            ->delete();

        return response('Restriction deleted', 200);
    }

    /**
     * Search restriction items
     *
     * @param Request $request
     * @param $discount_id
     * @param $restriction_name
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\JsonResponse|\Illuminate\Http\Response
     */
    public function search(Request $request, $discount_id, $restriction_name)
    {
        if (!config('discounts.restrictions.' . $restriction_name)) {
            return response('Restriction not found', 404);
        }

        $discount = App::make('discount')->find($discount_id);

        if (!$discount) {
            return response('Discount not found', 404);
        }

        $discount_restrictions = $discount->restrictions()
            ->where('discountable_type', $restriction_name)
            ->pluck('discountable_id');

        $items = App::make(Relation::getMorphedModel($restriction_name))
            ->newQuery()
            ->where(function ($query) use ($request) {
                $query->where('id', (int)$request->input('query'))
                    ->orWhere('name', 'LIKE' , '%' . $request->input('query') . '%');
            })
            ->whereNotIn('id', $discount_restrictions)
            ->get();

        return response()->json([
            'items' => $items
        ]);
    }

    /**
     * Toogle exclude
     *
     * @param Request $request
     * @param $restriction_id
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function toggleExclude(Request $request, $restriction_id)
    {
        $restriction = App::make('discount-restriction')
            ->newQuery()
            ->where('id', $restriction_id)
            ->first();

        if (!$restriction) {
            return response('Restriction not found', 404);
        }

        $restriction->exclude = !$restriction->exclude;
        $restriction->save();
        $response_text = $restriction->exclude ? 'excluded' : 'included';
        return response('Restriction ' . $response_text, 200);
    }

}
