<?php

namespace Mtc\MultiBuy\Console\Commands;

use Illuminate\Console\Command;
use Mtc\MultiBuy\Providers\DiscountServiceProvider;
use Mtc\MultiBuy\Seeds\DiscountsSeeder;

/**
 * Class InstallDiscounts
 * @package Mtc\MultiBuy\Console\Commands
 */
class InstallDiscounts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:discounts';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Discounts default assets/data';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Discounts');
        $this->callSilent('migrate');

        $this->callSilent('vendor:publish', [
            '--provider' => DiscountServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->comment('Setting up database');
        $this->call('db:seed', [
            '--class' => DiscountsSeeder::class
        ]);

        $this->info('Discounts installed successfully.');
    }
}
