<?php

namespace Mtc\MultiBuy\Validators;

use Mtc\MultiBuy\Discount;

/**
 * Class BasketPrice
 * @package Mtc\MultiBuy\Validators
 */
class BasketPrice
{
    /**
     * @param Discount $discount
     * @param $basket
     * @return bool
     */
    public function validate(Discount $discount, $basket): bool
    {
        //Check if discount have min basket price
        //Check if basket cost subtotal > discount min basket price
        if (
            $discount->getBasicRestriction('minimum_basket_price') > 0 &&
            $basket->cost_subtotal <= $discount->getBasicRestriction('minimum_basket_price')
        ) {
            return false;
        }

        return true;
    }
}
