<?php

namespace Mtc\MultiBuy\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Relations\Relation;

/**
 * Class StackablesController
 * @package Mtc\MultiBuy\Http\Controllers\Admin
 */
class StackablesController extends Controller
{
    /**
     * Get stackable discounts
     *
     * @param Request $request
     * @param $discount_id
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request, $discount_id)
    {
        $stackables = App::make('discount')
            ->newQuery()
            ->with('stackables')
            ->where('id', $discount_id)
            ->get()
            ->pluck('stackables')
            ->flatten();

        return response()->json([
            'stackables' => $stackables
        ]);
    }

    /**
     * Store stackable
     *
     * @param Request $request
     * @param $discount_id
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function store(Request $request, $discount_id)
    {
        $discount = App::make('discount')->find($discount_id);
        $stackable_discount = App::make('discount')->find($request->input('stackable_discount_id'));
        $discount->stackables()->attach($stackable_discount);
    }

    /**
     * Destroy stackable discount
     *
     * @param Request $request
     * @param $discount_id
     * @param $stackable_discount_id
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function destroy(Request $request, $discount_id, $stackable_discount_id)
    {
        $discount = App::make('discount')->find($discount_id);
        $discount->stackables()->detach($stackable_discount_id);

        return response('Stackable discount removed', 200);
    }

    /**
     * Search stackable discounts
     *
     * @param Request $request
     * @param $discount_id
     * @param $restriction_name
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\JsonResponse|\Illuminate\Http\Response
     */
    public function search(Request $request, $discount_id)
    {
        $discount = App::make('discount')->find($discount_id);
        $discounts = App::make('discount')
            ->newQuery()
            ->where(function ($query) use ($request) {
                $query->where('id', (int)$request->input('query'))
                    ->orWhere('name', 'LIKE', '%' . $request->input('query') . '%');
            })
            ->whereNotIn('id', $discount->stackables->pluck('id'))
            ->where('id', '<>', $discount_id)
            ->get();

        return response()->json([
            'discounts' => $discounts
        ]);
    }
}
