<?php

namespace Mtc\MultiBuy\Validators;

use Mtc\Modules\Members\Classes\Auth;
use Mtc\MultiBuy\Discount;

/**
 * Class MembersOnly
 * @package Mtc\MultiBuy\Validators
 */
class MembersOnly
{
    /**
     * @param Discount $discount
     * @param $basket
     * @return bool
     */
    public function validate(Discount $discount, $basket) : bool
    {
        //Check if first purchase enabled
        if (!$discount->getBasicRestriction('members_only')) {
            return true;
        }

        //Check if member
        if (Auth::getLoggedInMember()->exists) {
            return true;
        }

        return false;
    }
}
