<?php

namespace Mtc\MultiBuy\Validators;

use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\MultiBuy\Discount;

/**
 * Class StackWithCoupon
 * @package Mtc\MultiBuy\Validators
 */
class StackWithCoupon
{
    /**
     * @param Discount $discount
     * @param $item
     * @return bool
     */
    public function validate(Discount $discount, $item) : bool
    {
        if (!config('discounts.basic_restrictions.stack_with_coupons.enabled') || $discount->getBasicRestriction('stack_with_coupons')) {
            return true;
        }

        //Get basket current items
        $basket_repository = App::make(BasketRepositoryInterface::class);
        $item_applicable_for_coupon = $basket_repository->getModel()
            ->discounts()
            ->where('discount_type', 'coupon')
            ->get()
            ->filter(function($basket_coupon) use ($item) {
                $applicable_items = $basket_coupon->applicable_items ?: [];
                return in_array($item->purchasable->node->id, $applicable_items);
            })
            ->count();

        return !$item_applicable_for_coupon;
    }
}
