<?php

namespace Mtc\MultiBuy\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Mtc\Foundation\Rules\OptionalDMYDate;

/**
 * Class CreateDiscountRequest
 *
 * @package Mtc\MultiBuy\Http\Requests
 */
class CreateDiscountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return collect(config('discounts.basic_restrictions'))
            ->map(function($basic_restriction) {
                return $basic_restriction['request_rule'];
            })
            ->merge([
                'name' => 'required',
                'type' => [
                    'required',
                    Rule::in(array_keys(config('discounts.discount_types', [])))
                ],
                'value1' => 'required|numeric',
                'value2' => 'nullable|numeric',
                'disabled' => 'nullable|integer',
                'sale_restriction' => 'nullable|integer',
                'valid_from' => new OptionalDMYDate(),
                'valid_to' => new OptionalDMYDate(),
            ])
            ->toArray();
    }
}
