<?php

namespace Mtc\MultiBuy\Listeners;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Event;
use Mtc\Basket\Basket;
use Mtc\Basket\Repositories\BasketRepository;
use Mtc\MultiBuy\Contracts\BasketDiscountRepositoryInterface;

/**
 * Class SetBasketDiscount
 * @package Mtc\MultiBuy\Listeners
 */
class SetBasketDiscount
{
    /**
     * @var BasketRepository|Basket
     */
    protected $event;

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return array|null
     */
    public function handle($event)
    {
        if (!config('discounts.enabled', false)) {
            return null;
        }

        if (config('discounts.dispatch_event_before_adding_to_basket')) {
            Event::dispatch(SetBasketDiscount::class, $event);
        }

        $this->event = $event;
        $basket_discount_repository = App::make(BasketDiscountRepositoryInterface::class);
        $basket_discount_repository->setBasket($this->getBasket());
        $basket_discount_repository->setBasketDiscounts();
    }

    /**
     * Get Basket from event
     *
     * @return Model
     */
    protected function getBasket(): Model
    {
        return $this->event->getModel();
    }
}
