<?php

namespace Mtc\MultiBuy\Restrictions;

use Illuminate\Support\Facades\App;
use Mtc\MultiBuy\Discount;

/**
 * Class ItemRestriction
 * @package Mtc\MultiBuy\Restrictions
 */
class ItemRestriction
{
    /**
     * @param Discount $discount
     * @param $item
     * @param $restriction
     * @param $restrictions_count
     * @return bool
     */
    public function validate(Discount $discount, $item, $restriction, $restrictions_count)
    {
        // Discount doesn't have any restriction
        if (!$restrictions_count['excluded'] && !$restrictions_count['included']) {
            return false;
        }

        $purchasable_item = $item->purchasable->item ?: $purchasable_item->purchasable;
        $check_item_restriction = $purchasable_item->id === $restriction->discountable_id;

        // Discount contains only excluded restrictions
        if ($restrictions_count['excluded'] && !$restrictions_count['included']) {
            return !($check_item_restriction);
        }

        // Discount contains only included restrictions
        if ($restrictions_count['included'] && !$restrictions_count['excluded']) {
            return $check_item_restriction;
        }

        // Discount contains both included and excluded restrictions
        return $restriction->exclude ? !$check_item_restriction : $check_item_restriction;
    }
}
