<?php


namespace Mtc\MultiBuy\Types;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Core\Node;
use Mtc\MultiBuy\Contracts\BasketDiscountRepositoryInterface;
use Mtc\MultiBuy\Contracts\TypeContract;
use Mtc\Shop\Item;


class AddGiftAfterAmount implements TypeContract
{
    /**
     * Apply set amount discount to basket
     *
     * @param Model $discount
     * @return void
     */

    public function apply(Model $discount, $basket)
    {
        $basket_discount_repository = App::make(BasketDiscountRepositoryInterface::class);
        $basket_discount_repository->setBasket($basket);
        $applicable_items = $basket_discount_repository->getDiscountApplicableItems($discount);

        $total_basket_sum = $applicable_items->sum(
            function ($item) {
                return $item->unit_price;
            }
        );

        if ($total_basket_sum > $discount->getBasicRestriction('minimum_basket_price')) {
            $item_id = (int)$discount->value1;
            $product = $this->getDiscountedProduct($item_id);
            $basket_repository = App::make(BasketRepositoryInterface::class);
            $basket_repository->find($basket->id);
            $basket_repository->addItem($product, 1, false);
            $discount->discounted_amount = $product->getPrice()->raw();
        }
    }

    /**
     * Gets gift product from {VALUE1}
     *
     * @param int $item_id
     * @return Item
     */
    public function getDiscountedProduct(int $item_id): Item
    {
        return Item::query()->find($item_id);
    }

    /**
     * Get Discounted values for item line
     *
     * @param $discount
     * @param $item
     */
    public function getDiscountedValues($discount, $item)
    {
    }
}
