<?php

namespace Mtc\MultiBuy\Validators;

use Mtc\Members\Facades\MemberAuth;
use Mtc\MultiBuy\Discount;

/**
 * Class MembersOnly
 * @package Mtc\MultiBuy\Validators
 */
class MembersOnly
{
    /**
     * @param Discount $discount
     * @param $basket
     * @return bool
     */
    public function validate(Discount $discount, $basket): bool
    {
        //Check if first purchase enabled
        if (!$discount->getBasicRestriction('members_only')) {
            return true;
        }

        //Check if member
        if (MemberAuth::check()) {
            return true;
        }

        return false;
    }
}
