<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Multi Buy package
    |--------------------------------------------------------------------------
    |
    | Enabled/disabled package
    */
    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Provider classes
    |--------------------------------------------------------------------------
    |
    | Additional service providers.
    |
    */
    'service_providers' => [
        \Mtc\MultiBuy\Providers\DiscountRouteServiceProvider::class,
        \Mtc\MultiBuy\Providers\DiscountEventServiceProvider::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Class bindings
    |--------------------------------------------------------------------------
    |
    | These settings define classes that will be used by the application
    |
    */
    'discount_class' => \Mtc\MultiBuy\Discount::class,
    'restriction_class' => \Mtc\MultiBuy\Restriction::class,
    'repositories' => [
        'discount' => \Mtc\MultiBuy\Repositories\DiscountRepository::class,
        'basket_discount' => \Mtc\MultiBuy\Repositories\BasketDiscountRepository::class
    ],

    /*
    |--------------------------------------------------------------------------
    | Admin search filters
    |--------------------------------------------------------------------------
    |
    | Classes that will implement search filters on order admin list page
    | Each class is expected to follow the format of AdminFilter interface
    |
    */

    'admin_search_filters' => [
        \Mtc\MultiBuy\Filters\FilterByName::class,
    ],

    'admin' => [
        'pagination' => 20,
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Dispatch Event Before adding discounts to basket
    |--------------------------------------------------------------------------
    |
    | Before setting up basket discounts, dispatch event to do actions, that will
    | affect discounts availability
    | (e.g. set coupon applicable items, where these items aren't applicable for
    | discount)
    |
    */
    'dispatch_event_before_adding_to_basket' => true,
    
    /*
    |--------------------------------------------------------------------------
    | Supported Discount types
    |--------------------------------------------------------------------------
    |
    | We set the supported discount types here
    | Discount Types allow applying different techniques for discounts
    |
    */
    'discount_types' => [
        'percentoff' => [
            'description' => '{VALUE1} percent off discount per item',
            'class' => \Mtc\MultiBuy\Types\PercentOff::class
        ],
        'percentoffall' => [
            'description' => '{VALUE1} percent off to basket',
            'class' => \Mtc\MultiBuy\Types\PercentOffAll::class
        ],
        'amountoff' => [
            'description' => '{VALUE1} amount discount per item',
            'class' => \Mtc\MultiBuy\Types\AmountOff::class
        ],
        'amountoffall' => [
            'description' => '{VALUE1} amount discount to basket',
            'class' => \Mtc\MultiBuy\Types\AmountOffAll::class
        ],
        'amountForTwoItemsInCat' => [
            'description' => 'For each {VALUE2} items, price will be {VALUE1} for each item',
            'class' => \Mtc\MultiBuy\Types\FixedAmountPerTwoItemsInCategory::class
        ],
        'giftAfterCertainAmount' => [
            'description' => 'Get free item with ID: {VALUE1}',
            'class' => \Mtc\MultiBuy\Types\AddGiftAfterAmount::class
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Restrictions information
    |--------------------------------------------------------------------------
    |
    | Show information text before restrictions
    */

    'restrictions_information_text' => true,

    /*
    |--------------------------------------------------------------------------
    | Restrictions
    |--------------------------------------------------------------------------
    |
    | Define the base restrictions
    | Restriction contains:
    |  - Morph alias
    |  - Description
    |  - Validation class
    |  - Priority (Higher priority will ignore lower priority restrictions)
    |
    */
    'restrictions' => [
        'item' => [
            'priority' => 10,
            'description' => 'Items restrictions',
            'validation' => \Mtc\MultiBuy\Restrictions\ItemRestriction::class
        ],
        'category' => [
            'priority' => 9,
            'description' => 'Category restrictions',
            'validation' => \Mtc\MultiBuy\Restrictions\CategoryRestriction::class
        ],
        'brand' => [
            'priority' => 8,
            'description' => 'Brand restrictions',
            'validation' => \Mtc\MultiBuy\Restrictions\BrandRestriction::class
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Basic restrictions
    |--------------------------------------------------------------------------
    |
    | Basket validation
    |
    */
    'basic_restrictions' => [
        'minimum_basket_price' => [
            'enabled' => true,
            'type' => 'text',
            'request_rule' => 'nullable|numeric',
            'description' => 'Minimum Basket Value (£)',
            'validator' => \Mtc\MultiBuy\Validators\BasketPrice::class,
        ],
        'members_only' => [
            'enabled' => true,
            'type' => 'checkbox',
            'request_rule' => 'nullable|integer',
            'description' => 'Members only',
            'validator' => \Mtc\MultiBuy\Validators\MembersOnly::class,
        ],
        'only_first_purchase' => [
            'enabled' => true,
            'type' => 'checkbox',
            'request_rule' => 'nullable|integer',
            'description' => 'Only first purchase',
            'validator' => \Mtc\MultiBuy\Validators\FirstPurchase::class,
        ],
        'stack_with_coupons' => [
            'enabled' => true,
            'type' => 'checkbox',
            'request_rule' => 'nullable|integer',
            'description' => 'Stack with coupons',
            'validator' => null,
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Validation per item
    |--------------------------------------------------------------------------
    |
    | Validations goes after basic restrictions (basket validation)
    | Mark basket item as applicable
    |
    */
    'item_checks' => [
        \Mtc\MultiBuy\Validators\DiscountableItem::class,
        \Mtc\MultiBuy\Validators\StackWithCoupon::class
    ],

    /*
    |--------------------------------------------------------------------------
    | Sale Restrictions
    |--------------------------------------------------------------------------
    |
    | Define the sale restrictions
    | These restrictions will be used to verify coupon applies to basket
    */
    'sale_restrictions' => [
        \Mtc\MultiBuy\Discount::ALL_ITEMS => 'Applies to both sale and non-sale items',
        \Mtc\MultiBuy\Discount::NON_SALE_ITEMS => 'Applies to only non-sale items',
        \Mtc\MultiBuy\Discount::ONLY_SALE_ITEMS => 'Applies to only sale items',
    ],

    /*
    |--------------------------------------------------------------------------
    | Chart
    |--------------------------------------------------------------------------
    |
    | Chart to show dependent on the discount
    |
    */
    'chart' => [
        'enabled' => false,
        'step_size' => 1,
        'group_by' => [
            0 => 'Days',
            1 => 'Months',
            2 => 'Years'
        ]
    ]

];
