<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateMultiBuyTables
 */
class CreateMultiBuyTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discounts', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->index();
            $table->string('type')->index();
            $table->decimal('value1', 10)->default(0);
            $table->decimal('value2', 10)->default(0);
            $table->boolean('disabled')->default(0)->index();
            $table->boolean('allstock')->default(0);
            $table->decimal('min_basket_price', 10)->nullable()->index();
            $table->boolean('only_first_purchase')->default(0);
            $table->datetime('valid_from')->nullable()->index();
            $table->datetime('valid_to')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('discount_restrictions', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('discount_id')->index();
            $table->morphs('discountable');
            $table->boolean('exclude')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discounts');
        Schema::dropIfExists('discount_restrictions');
    }
}
