<?php

namespace Mtc\MultiBuy\Restrictions;

use Mtc\MultiBuy\Discount;

/**
 * Class CategoryRestriction
 * @package Mtc\MultiBuy\Restrictions
 */
class CategoryRestriction
{
    /**
     * @param Discount $discount
     * @param $item
     * @param $restriction
     * @param $restrictions_count
     * @return bool
     */
    public function validate(Discount $discount, $item, $restriction, $restrictions_count): bool
    {
        // Discount doesn't have any restriction
        if (!$restrictions_count['excluded'] && !$restrictions_count['included']) {
            return false;
        }

        $categories = $item->purchasable->categories ?: $item->purchasable->item->categories;
        $restriction_category_exists = $categories
            ->contains('id', $restriction->discountable_id);

        // Discount contains only excluded restrictions
        if ($restrictions_count['excluded'] && !$restrictions_count['included']) {
            return !(bool)$restriction_category_exists;
        }

        // Discount contains only included restrictions
        if ($restrictions_count['included'] && !$restrictions_count['excluded']) {
            return (bool)$restriction_category_exists;
        }

        // Discount contains both included and excluded restrictions
        return $restriction->exclude ? !(bool)$restriction_category_exists : (bool)$restriction_category_exists;
    }
}
