<?php

namespace Mtc\MultiBuy\Types;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\MultiBuy\Contracts\BasketDiscountRepositoryInterface;
use Mtc\MultiBuy\Contracts\TypeContract;

class FixedAmountPerTwoItemsInCategory implements TypeContract
{
    /**
     * @var null
     */
    protected $discount = null;

    /**
     * Total item quantity that meets this discount type criteria
     *
     * @var int
     */
    protected int $total_applicable_quantity = 0;

    /**
     * Total quantity used for applying discount to items
     *
     * @var int
     */
    protected int $used_quantity = 0;

    /**
     * Apply set amount discount to basket
     *
     * @param Model $discount
     * @return void
     */

    public function apply(Model $discount, $basket)
    {
        $this->discount = $discount;
        $this->basket = $basket;
        $basket_discount_repository = App::make(BasketDiscountRepositoryInterface::class);
        $basket_discount_repository->setBasket($basket);
        $applicable_items = $basket_discount_repository->getDiscountApplicableItems($discount);

        $total_applicable_item_quantity = $applicable_items->sum('quantity');
        $this->total_applicable_quantity = intdiv($total_applicable_item_quantity, $this->discount->value2)
            * $this->discount->value2;

        $discount->discounted_amount = $applicable_items->sum(
            function ($item) {
                if ($this->total_applicable_quantity > $this->used_quantity) {
                    return $this->applyToItem($item);
                }
                return 0;
            }
        );
    }

    /**
     * Apply set amount discount to item
     *
     * @param $item
     * @return float|int
     */
    protected function applyToItem($item)
    {
        $item_applicable_quantity = min($this->total_applicable_quantity - $this->used_quantity, $item->quantity);

        $this->used_quantity += $item_applicable_quantity;

        $item_price = (!config('basket.discount_vat_outside_default_region'))
            ? $item->unit_price
            : $item->unit_price_ex_vat;

        $discounted_price = ($item_price > $this->discount->value1 ? $item_price - $this->discount->value1 : 0);
        return $discounted_price * $item_applicable_quantity;
    }

    /**
     * @inheritDoc
     */
    public function getDiscountedValues($discount, $item)
    {
        // TODO: Implement getDiscountedValues() method.
    }
}
