<?php

namespace Mtc\MultiBuy\Types;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\MultiBuy\Contracts\BasketDiscountRepositoryInterface;
use Mtc\MultiBuy\Contracts\TypeContract;

/**
 * Class PercentOff
 * @package Mtc\MultiBuy
 */
class PercentOff implements TypeContract
{
    /**
     * @var null
     */
    protected $discount = null;

    /**
     * Apply Percent Off Discount to Basket
     *
     * @param Model $discount
     * @param $basket
     */
    public function apply(Model $discount, $basket)
    {
        $this->discount = $discount;
        $this->basket = $basket;

        $basket_discount_repository = App::make(BasketDiscountRepositoryInterface::class);
        $basket_discount_repository->setBasket($basket);
        $applicable_items = $basket_discount_repository->getDiscountApplicableItems($discount);
        //Total discounted amount by this discount
        $discount->discounted_amount = $applicable_items->sum(function ($item) {
            return $this->applyToItemLine($item);
        });
    }

    /**
     * Apply Percentage Discount to Item
     *
     * @param $item
     * @return float|int
     */
    protected function applyToItemLine($item)
    {
        return round($item->line_total / 100 * $this->discount->value1, 2);
    }

    /**
     * Get Discounted values for item line
     *
     * @param $discount
     * @param $item
     * @return float
     */
    public function getDiscountedValues($discount, $item)
    {
        return [
            'discounted_percent' => $discount->value1
        ];
    }
}
