<?php

namespace Mtc\MultiBuy\Types;

use Illuminate\Database\Eloquent\Model;
use Mtc\MultiBuy\Contracts\TypeContract;

/**
 * Class PercentOffAll
 * @package Mtc\MultiBuy
 */
class PercentOffAll implements TypeContract
{
    /**
     * Apply Percent of All Discount to Basket
     *
     * @param Model $discount
     * @return void
     */
    public function apply(Model $discount, $basket)
    {
        $discount->discounted_amount = round($basket->getCostSubtotalAttribute() / 100 * $discount->value1, 2);
    }

    /**
     * Get Discounted values for item line
     *
     * @param $discount
     * @param $item
     * @return float
     */
    public function getDiscountedValues($discount, $item)
    {
        return [
            'discounted_percent' => $discount->value1
        ];
    }
}
