<?php

namespace MtcMedia\Mvc;

use Illuminate\Container\Container;
use Illuminate\Routing\Router;

/**
 * @author Aleksey Lavrinenko
 * @version 28.02.2016.
 */
class RoutingComponent
{
    /**
     * @var Container
     */
    protected $app;

    /**
     * @var bool
     */
    protected $hide_live_exception = true;

    /**
     * Sets live NotFound Exception behavior
     * @param bool $hide_live_exception
     */
    public function setHideLiveException($hide_live_exception)
    {
        $this->hide_live_exception = $hide_live_exception;
    }

    public function __construct(Container $app)
    {
        $this->app = $app;
    }

    public function register($root = null)
    {
        $app = $this->app;

        // the below are required for routing/controllers

        // first register the request
        if (!$app->bound('request')) {
            $request = \Illuminate\Http\Request::capture();
            $app['request'] = $request;
        } else {
            $request = $app['request'];
        }

        if (!$app->bound(Illuminate\Http\Request::class)) {
            // add alias to make Request method args resolve to this same instance
            $app->alias('request', \Illuminate\Http\Request::class);
        }

        // events is the dependency of RoutingServiceProvider
        if (!$app->bound('events')) {
            (new \Illuminate\Events\EventServiceProvider($app))->register();
        }

        // check each if not already registered
        if (!$app->bound('router')) {
            (new \Illuminate\Routing\RoutingServiceProvider($app))->register();
        }

        // this one doesn't register anything on the container
        (new \Illuminate\Pagination\PaginationServiceProvider($app))->register();

        if (!isset($root)) {
            // auto detect module root - it's the directory with the bootstrap file
            $root = dirname($request->server('PHP_SELF'));
        }
        $app['module_root'] = $root;
    }

    public function handleRequest($request = null)
    {
        $app = $this->app;

        if ($request === null) {
            $request = $app['request'];
        }

        try {
            // Dispatch the router
            $response = $app['router']->dispatch($request);

            // Send the response
            $response->send();
        } catch(\Symfony\Component\HttpKernel\Exception\NotFoundHttpException $notFound) {
            if (!DEV_MODE && $this->hide_live_exception) {
                with(new \Illuminate\Http\Response('Oops! this page does not exist', 404))->send();
            }
            throw $notFound;
        }
    }

    /**
     * @return Router
     */
    public function getRouter()
    {
        return $this->app['router'];
    }

    /**
     * Returns list of routes as array
     * @return array
     */
    public function listRoutes()
    {
        $router = $this->getRouter();

        $results = [];
        foreach ($router->getRoutes() as $route) {
            $results[] = [
                'host'   => $route->domain(),
                'method' => implode('|', $route->methods()),
                'uri'    => $route->uri(),
                'name'   => $route->getName(),
                'action' => $route->getActionName(),
            ];
        }
        return $results;
    }
}
