<?php

use Illuminate\Routing\Router;
use Mtc\Notifications\Http\Controllers\NotificationViewController;
use Mtc\Notifications\Http\Controllers\NotificationController;

/** @var Router $router */
$router->group([
    'prefix' => config('admin.route_prefix'),
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->post('/notification-centre', [ NotificationController::class, 'index' ])->name('notifications.view');
    $router->put('/notification-centre/mark-read', [ NotificationController::class, 'markRead' ])->name('notifications.mark-read');
    $router->put('/notification-centre/mark-unread', [ NotificationController::class, 'markUnread' ])->name('notifications.mark-unread');
    $router->put('/notification-centre/delete', [ NotificationController::class, 'destroy' ])->name('notifications.delete');
});
