<?php

namespace Mtc\Notifications\Contracts;

use Mtc\Notifications\Factories\NotificationFactory;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

abstract class NotificationModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'notifications';

    /**
     * @var string[]
     */
    protected $guarded = [
        'id'
    ];

    /**
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function readBy()
    {
        return $this->belongsTo(Authenticatable::class, 'read_by');
    }

    /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return NotificationFactory::new();
    }

    protected static function boot()
    {
        parent::boot();

        self::addGlobalScope(function ($query) {
            $query->latest();
        });
    }
}
