<?php

namespace Mtc\Notifications\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Notifications\Models\Notification;

class NotificationFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Notification::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'severity' => $this->faker->randomKey(array_flip($this->severities())),
            'message' => $this->faker->randomKey(array_flip($this->messages())),
            'details' => $this->faker->paragraph,
            'source' => $this->faker->randomKey(array_flip($this->sources())),
            'recipient_permission_level' => null,
        ];
    }

    private function severities()
    {
        return [
            'info',
            'warning',
            'error',
            'critical'
        ];
    }

    private function sources()
    {
        return [
            null,
            '/admin',
            '/admin/users'
        ];
    }

    public function messages()
    {
        return [
            'Order XXX failed exporting to EPOS',
            'New Customer Enquiry',
            'New Order placed',
            'An issue occurred creating order shipment',
        ];
    }
}
