<?php

namespace Mtc\Notifications\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mtc\Notifications\Contracts\NotificationModel;
use Mtc\Notifications\Facades\Notification;
use Mtc\Notifications\Http\Requests\NotificationRequest;

class NotificationController
{
    /**
     * List notifications for given user
     *
     * @param Request $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function index(Request $request)
    {
        if ($request->has('view_all')) {
            return Notification::getAll(Auth::user());
        }
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }

    /**
     * Mark notifications as read
     *
     * @param NotificationRequest $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function markRead(NotificationRequest $request)
    {
        Notification::markRead($request->input('notification_ids'), Auth::user());
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }

    /**
     * Mark notifications as unread
     *
     * @param NotificationRequest $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function markUnread(NotificationRequest $request)
    {
        Notification::markUnread($request->input('notification_ids'), Auth::user());
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }

    /**
     * Clear notifications
     *
     * @param NotificationRequest $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function destroy(NotificationRequest $request)
    {
        Notification::destroy($request->input('notification_ids'));
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }
}
