<?php

namespace Mtc\Notifications\Tests\Unit;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\Notifications\Contracts\NotificationModel;
use Mtc\Notifications\Facades\Notification;
use Mtc\Notifications\Http\Resources\NotificationList;
use Mtc\Notifications\Tests\TestCase;

class NotificationResourceTest extends TestCase
{
    use DatabaseMigrations;

    protected function prepareResource(): NotificationList
    {
        Notification::addNotification('info', 'test', 'details', 'lorem', 'source');
        Notification::addNotification('warning', 'test2', 'details', 'ipsum', 'source');

        return new NotificationList(app(NotificationModel::class)->all());
    }

    public function test_does_not_have_updated_timestamp(): void
    {
        $resource_array = $this->prepareResource()->toArray(request());
        collect($resource_array)
            ->each(fn($resource) => self::assertArrayNotHasKey('updated_at', $resource));
    }

    public function test_has_when_attribute(): void
    {
        $resource_array = $this->prepareResource()->toArray(request());
        ;
        collect($resource_array)
            ->each(fn($resource) => self::assertArrayHasKey('when', $resource));

    }

    public function test_has_time_ago_attribute(): void
    {
        $resource_array = $this->prepareResource()->toArray(request());
        collect($resource_array)
            ->each(fn($resource) => self::assertArrayHasKey('time_ago', $resource));
    }
}
