<?php

namespace Mtc\Notifications\Contracts;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;

abstract class NotificationModel extends Model
{

    /**
     * @var string
     */
    protected $table = 'notifications';

    /**
     * @var string[]
     */
    protected $guarded = [
        'id'
    ];

    /**
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * @var string[]
     */
    protected $appends = [
        'view_url',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function readBy()
    {
        return $this->belongsTo(Authenticatable::class, 'read_by');
    }


    protected static function boot()
    {
        parent::boot();

        self::addGlobalScope(function ($query) {
            $query->latest();
        });
    }

    /**
     * @return string
     */
    public function getViewUrlAttribute()
    {
        return route('notifications.show', $this);
    }
}
