<?php

namespace Mtc\Notifications\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mtc\Notifications\Contracts\NotificationModel;
use Mtc\Notifications\Facades\Notification;

class NotificationController
{
    /**
     * @param Request $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function index(Request $request)
    {
        if ($request->has('view_all')) {
            return Notification::getAll(Auth::user());
        }
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }

    /**
     * @return array
     */
    public function check()
    {
        return [
            'has_notifications' => Notification::hasUnread(Auth::user()),
        ];
    }

    /**
     * @param NotificationModel $notification
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function show(NotificationModel $notification)
    {
        Notification::markRead($notification->id, Auth::user());
        return $notification->source ? redirect($notification->source) : redirect(route('notifications.index'));
    }

    /**
     * @param Request $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function markRead(Request $request)
    {
        Notification::markRead($request->input('notification_ids'), Auth::user());
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }

    /**
     * @param Request $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function markUnread(Request $request)
    {
        Notification::markUnread($request->input('notification_ids'), Auth::user());
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }

    /**
     * @param Request $request
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function destroy(Request $request)
    {
        Notification::destroy($request->input('notification_ids'));
        return Notification::getAll(Auth::user(), $request->input('per_page'));
    }
}
