<?php

namespace Mtc\Notifications\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\Notifications\Contracts\NotificationModel;

class NotificationList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource
            ->each(function (NotificationModel  $notification) {
                $notification->setHidden([
                    'updated_at'
                ]);

                $notification->when = $notification->created_at->format('d/m/Y H:i');
                $notification->time_ago = $notification->created_at->diffForHumans(Carbon::now());
            });
        return parent::toArray($request);
    }
}
