<?php

use Illuminate\Routing\Router;
use Mtc\Notifications\Http\Controllers\NotificationViewController;
use Mtc\Notifications\Http\Controllers\NotificationController;

/** @var Router $router */
$router->group([
    'prefix' => 'api/',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {

    $router->get('/notification-centre', [ NotificationViewController::class, 'index' ])->name('notifications.index');

    $router->post('/notification-centre', [ NotificationController::class, 'index' ])->name('notifications.view');
    $router->get('/notification-centre/{notification}', [ NotificationController::class, 'show' ])->name('notifications.show');
    $router->put('/notification-centre/mark-read', [ NotificationController::class, 'markRead' ])->name('notifications.mark-read');
    $router->put('/notification-centre/mark-unread', [ NotificationController::class, 'markUnread' ])->name('notifications.mark-unread');
    $router->put('/notification-centre/delete', [ NotificationController::class, 'destroy' ])->name('notifications.delete');

});
